<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationsTable extends Migration {

	public function up()
	{
		Schema::create('donations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('organization_id')->unsigned()->nullable();
			$table->integer('project_id')->unsigned();
			$table->integer('participant_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->text('message')->nullable();
			$table->decimal('amount', 9,2);
			$table->decimal('fee', 9,2);
			$table->decimal('fee_ex_tax', 9,2);
			$table->decimal('fee_percentage', 9,2);
			$table->decimal('net_amount', 9,2);
			$table->boolean('received_response');
			$table->boolean('anonymous');
			$table->boolean('test');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('donations');
	}
}