<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('transactionable_id')->unsigned();
			$table->string('transactionable_type');
			$table->decimal('amount', 9,2);
			$table->decimal('transaction_costs', 9,2);
			$table->decimal('transaction_costs_ex_tax', 9,2);
			$table->decimal('tax_percentage', 9,2);
			$table->string('payment_method');
			$table->string('description');
			$table->string('status');
			$table->date('processed_at')->nullable();
			$table->date('payed_out_at')->nullable();
			$table->string('batch_id')->nullable();
			$table->integer('subscription_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}