<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObjectsTable extends Migration {

	public function up()
	{
		Schema::create('objects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('object_type_id')->unsigned()->index();
			$table->string('original_image', 255);
			$table->bigInteger('uuid')->index();
		});
	}

	public function down()
	{
		Schema::drop('objects');
	}
}