<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');

    public function blogsposted()
    {
        return $this->hasMany('Blog', 'user_id');
    }

    public function commentsposted()
    {
        return $this->hasMany('Comment', 'user_id');
    }

    public function likesposted()
    {
        return $this->hasMany('LikeUser', 'user_id');
    }

    public function imageposted()
    {
        return $this->hasMany('Image', 'user_id');
    }

}