<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'stock', 'base_price', 'has_options');

	public function options()
	{
		return $this->hasMany('Options');
	}

}