<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectReportTable extends Migration {

	public function up()
	{
		Schema::create('project_report', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->increments('id');
			$table->integer('project_id')->nullable();
			$table->integer('created_by')->nullable();
			$table->integer('to_member_id')->nullable();
			$table->string('status')->nullable();
			$table->string('title')->nullable();
			$table->text('report')->nullable();
			$table->string('respond')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project_report');
	}
}