<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Certification extends Eloquent {

	protected $table = 'certification';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('university', 'level', 'univer', 'collage', 'degree', 'year', 'description', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}