<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CheckItem extends Eloquent {

	protected $table = 'check_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('check_list_id', 'description', 'completed', 'created_by');

	public function list()
	{
		return $this->belongsTo('CheckList', 'check_list_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

}