<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ChildName extends Eloquent {

	protected $table = 'child_name';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}