<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CommentMention extends Eloquent {

	protected $table = 'comment_mention';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('comment_id', 'created_by', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function comment()
	{
		return $this->belongsTo('PostComment', 'comment_id');
	}

}