<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Department extends Eloquent {

	protected $table = 'department';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'phone', 'parent_id', 'description_en', 'description_ar');

	public function department()
	{
		return $this->belongsTo('Department', 'parent_id');
	}

	public function subdepartment()
	{
		return $this->hasMany('Department', 'parent_id');
	}

	public function supervisors()
	{
		return $this->belongsToMany('Supervisor', 'supervisor', 'department_id', 'supervisor_id');
	}

	public function members()
	{
		return $this->belongsToMany('Member', 'member_department', 'department_id', 'member_id');
	}

}