<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FileHistory extends Eloquent {

	protected $table = 'file_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('created_by', 'description', 'drive_id');

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function drive()
	{
		return $this->belongsTo('Drive', 'drive_id');
	}

}