<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'group';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('created_by', 'name', 'about', 'send_invitations', 'who_approve', 'rate', 'folder_id', 'type', 'visible', 'approved_invitations', 'total_member');

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function tags()
	{
		return $this->belongsToMany('Tag', 'group_tag', 'group_id', 'tag_id');
	}

	public function admins()
	{
		return $this->belongsToMany('Member', 'group_admin', 'group_id', 'group_admin_id');
	}

	public function members()
	{
		return $this->belongsToMany('Member', 'group_member', 'group_id', 'member_id');
	}

	public function posts()
	{
		return $this->belongsToMany('Post', 'group_post', 'group_id', 'post_id');
	}

	public function rates()
	{
		return $this->hasMany('GroupRate', 'group_id');
	}

	public function folder()
	{
		return $this->belongsTo('Drive', 'folder_id');
	}

}