<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupAdmin extends Eloquent {

	protected $table = 'group_admin';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('group_admin_id', 'group_id');

	public function group_admin()
	{
		return $this->belongsTo('Member', 'group_admin_id');
	}

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

}