<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupMember extends Eloquent {

	protected $table = 'group_member';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'group_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

}