<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupPost extends Eloquent {

	protected $table = 'group_post';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'group_id');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

}