<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MemberDepartment extends Eloquent {

	protected $table = 'member_department';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'department_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function department()
	{
		return $this->belongsTo('Department', 'department_id');
	}

}