<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'post';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_type', 'created_by', 'title', 'description', 'expire_at', 'confirm_report', 'letter_number', 'alert_type_id', 'all_member');

	public function alert_type()
	{
		return $this->belongsTo('AlertType', 'alert_type_id');
	}

	public function members()
	{
		return $this->belongsToMany('Member', 'post_member', 'post_id', 'member_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function mentions()
	{
		return $this->belongsToMany('Member', 'post_mentions', 'post_id', 'membe_id');
	}

	public function schedules()
	{
		return $this->hasMany('PostSchedule', 'post_id');
	}

	public function reactions()
	{
		return $this->hasMany('PostReaction', 'post_id');
	}

	public function comments()
	{
		return $this->hasMany('PostComment', 'post_id');
	}

	public function followers()
	{
		return $this->belongsToMany('Member', 'post_follower', 'post_id', 'member_id');
	}

	public function views()
	{
		return $this->belongsToMany('Member', 'post_view', 'post_id', 'member_id');
	}

	public function reports()
	{
		return $this->hasMany('PostReport', 'post_id');
	}

	public function confirms()
	{
		return $this->belongsToMany('Member', 'post_confirm', 'post_id', 'member_id');
	}

	public function cities()
	{
		return $this->belongsToMany('City', 'post_city', 'post_id', 'city_id');
	}

}