<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostComment extends Eloquent {

	protected $table = 'post_comment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'message', 'reply_on', 'main_thread', 'created_by');

	public function comment()
	{
		return $this->belongsTo('PostComment', 'reply_on');
	}

	public function comments()
	{
		return $this->hasMany('PostComment', 'reply_on');
	}

	public function main_comment()
	{
		return $this->belongsTo('PostComment', 'main_thread');
	}

	public function member()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function mentions()
	{
		return $this->hasMany('CommentMention', 'comment_id');
	}

	public function reactions()
	{
		return $this->hasMany('CommentReaction', 'comment_id');
	}

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

}