<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostFollower extends Eloquent {

	protected $table = 'post_follower';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'post_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

}