<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostReport extends Eloquent {

	protected $table = 'post_report';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'member_id', 'reason');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}