<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectReport extends Eloquent {

	protected $table = 'project_report';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'created_by', 'to_member_id', 'status', 'title', 'report', 'respond', 'note');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function to_member()
	{
		return $this->belongsTo('Member', 'to_member_id');
	}

	public function creator()
	{
		return $this->belongsTo('Member', 'created_by');
	}

}