<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TaskAssign extends Eloquent {

	protected $table = 'task_assign';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('task_id', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function task()
	{
		return $this->belongsTo('Task', 'task_id');
	}

}