<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TaskHistory extends Eloquent {

	protected $table = 'task_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('task_id', 'created_by', 'description');

	public function task()
	{
		return $this->belongsTo('Task', 'task_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

}