<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupTable extends Migration {

	public function up()
	{
		Schema::create('group', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('created_by')->nullable();
			$table->string('name')->nullable();
			$table->text('about')->nullable();
			$table->enum('send_invitations', array('me', 'group_admin', 'all'))->nullable();
			$table->enum('who_approve', array('me', 'group_admin'))->nullable();
			$table->integer('rate')->nullable();
			$table->integer('folder_id')->nullable();
			$table->enum('type', array('public', 'private'))->nullable();
			$table->enum('visible', array('public', 'private'))->nullable();
			$table->boolean('approved_invitations')->nullable()->default(0);
			$table->integer('total_member')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('group');
	}
}