<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->datetime('suggestion_date')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->integer('created_by')->nullable();
			$table->integer('supervisor_id')->nullable();
			$table->text('comment')->nullable();
			$table->integer('progress')->nullable();
			$table->string('status')->nullable();
			$table->integer('percent')->nullable();
			$table->string('group_id')->nullable();
			$table->integer('folder_id')->nullable();
			$table->integer('total_days')->nullable();
			$table->integer('total_members')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}