<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostScheduleTable extends Migration {

	public function up()
	{
		Schema::create('post_schedule', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('post_id')->nullable();
			$table->datetime('date')->nullable();
			$table->boolean('publish')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('post_schedule');
	}
}