<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'address', 'image', 'api_token', 'region_id', 'pin_code');

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function region()
	{
		return $this->belongsTo('App\Models\Region');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function notifications()
	{
		return $this->morphMany('App\Models\Notification', 'notifiable');
	}

	public function tokens()
	{
		return $this->morphMany('App\Models\Token', 'tokenable');
	}

}