<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getCustomer()
	{
		return $this->belongsTo('App\Customer');
	}

	public function getAddress()
	{
		return $this->belongsTo('App\User');
	}

	public function paymentMethod()
	{
		return $this->belongsTo('App\PaymentMethod');
	}

}