<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductAttribute extends Eloquent {

	protected $table = 'product_attributes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getProducts()
	{
		return $this->belongsTo('App\Product');
	}

	public function getAttributes()
	{
		return $this->belongsTo('App\Attribute');
	}

}