<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Wishlist extends Eloquent {

	protected $table = 'wishlists';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getProduct()
	{
		return $this->belongsTo('App\Product');
	}

	public function getCustomer()
	{
		return $this->belongsTo('App\Customer');
	}

}