<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getCustomer()
    {
        return $this->belongsTo('App\Customer');
    }

    public function getAddress()
    {
        return $this->belongsTo('App\User');
    }

    public function paymentMethod()
    {
        return $this->belongsTo('App\PaymentMethod');
    }

}