<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->json('name');
			$table->string('phone', 255)->nullable()->default('010');
			$table->integer('company_size_id')->unsigned();
			$table->integer('company_group_id')->unsigned();
			$table->integer('work_type_id')->unsigned();
			$table->string('website_link')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}