<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('company_size_id')->references('id')->on('company_sizes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('company_group_id')->references('id')->on('company_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('work_type_id')->references('id')->on('work_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('work_type_id')->references('id')->on('work_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('reuqest_priority')->references('id')->on('request-priorities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('request_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('request_users', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('requests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_company_size_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_company_group_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_work_type_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_type_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_work_type_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_company_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_reuqest_priority_foreign');
		});
		Schema::table('request_users', function(Blueprint $table) {
			$table->dropForeign('request_users_user_id_foreign');
		});
		Schema::table('request_users', function(Blueprint $table) {
			$table->dropForeign('request_users_request_id_foreign');
		});
	}
}