<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('property_id')->unsigned();
			$table->integer('reservation_id')->unsigned();
			$table->integer('invoice_id')->unsigned();
			$table->mediumInteger('remain');
			$table->enum('pay_type', array('visa', 'cash'));
			$table->decimal('total_price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}