<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCareerRequestsTable extends Migration {

	public function up()
	{
		Schema::create('career_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('career_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->string('email', 191);
			$table->string('phone', 191);
			$table->string('country_code', 191);
			$table->string('file', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('career_requests');
	}
}