<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePricesTable extends Migration {

	public function up()
	{
		Schema::create('prices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->enum('type', array(''3hour'', ''6hour'', ''12hour'', ''day''));
			$table->decimal('price')->default('0');
			$table->decimal('mid_week')->default('0');
			$table->decimal('end_week')->default('0');
			$table->decimal('cleaning_fees')->default('0');
			$table->decimal('service_visitor_fees')->default('0');
			$table->decimal('our_service_fees')->default('0');
			$table->decimal('deposit_fees')->default('0');
			$table->json('times');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('prices');
	}
}