<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('properties', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->bigInteger('type_id')->unsigned();
			$table->json('advantages_id')->nullable();
			$table->json('facilities_id')->nullable();
			$table->json('location')->nullable();
			$table->json('kitchen_details')->nullable();
			$table->json('rooms_details')->nullable();
			$table->json('bathroom_details')->nullable();
			$table->json('place_rules_ids')->nullable();
			$table->json('is_included')->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->bigInteger('district_id')->unsigned()->nullable();
			$table->float('area')->default('0');
			$table->tinyInteger('tenant_count')->default('0');
			$table->enum('tenant_gender', array(''mail'', ''female''))->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description')->nullable();
			$table->enum('jetroom_type', array(''company'', ''individuale''));
			$table->boolean('is_updated')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('properties');
	}
}