<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestationsTable extends Migration {

	public function up()
	{
		Schema::create('questations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('question', 191);
			$table->string('question_ar', 191);
			$table->text('answer');
			$table->text('answer_ar');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('questations');
	}
}