<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('rateable_id')->unsigned()->nullable();
			$table->string('rateable_type', 191)->nullable();
			$table->tinyInteger('rate')->default('0');
			$table->text('comment')->nullable();
			$table->string('type', 191)->nullable();
			$table->boolean('is_active')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}