<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('number_of_guests');
			$table->datetime('check_in_date');
			$table->datetime('check_out_date');
			$table->smallInteger('check_in_hours')->nullable();
			$table->smallInteger('check_out_hours');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}