<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->string('email', 191)->unique();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('country_code', 191);
			$table->string('phone', 191);
			$table->timestamp('phone_verified_at')->nullable();
			$table->string('password', 191)->nullable();
			$table->string('image', 191)->nullable();
			$table->tinyInteger('is_active')->unsigned()->default('1');
			$table->string('register_from', 191)->nullable();
			$table->string('provider')->nullable();
			$table->string('provider_id')->nullable();
			$table->json('countries_id')->nullable();
			$table->json('languages')->nullable();
			$table->json('intersts')->nullable();
			$table->string('job_title', 191)->nullable();
			$table->date('birthday')->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->bigInteger('city_id')->unsigned()->nullable();
			$table->string('address', 191)->nullable();
			$table->string('nickname', 191)->nullable();
			$table->decimal('total_wallets')->default('0');
			$table->float('total_rates')->default('0');
			$table->decimal('total_points')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}