<?php

namespace OrderProduct;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderProduct extends Eloquent {

	protected $table = 'order_products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('Product');
	}

	public function order()
	{
		return $this->belongsTo('QuotationPrice');
	}

}