<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone', 255);
			$table->text('work');
			$table->string('address', 255);
			$table->date('birth');
			$table->integer('city_id')->unsigned();
			$table->integer('district_id')->unsigned();
			$table->integer('following_count');
			$table->string('password', 255);
			$table->integer('follower_count')->nullable();
			$table->string('api_token');
			$table->enum('sex', array('male', 'female'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}