<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMuridTable extends Migration {

	public function up()
	{
		Schema::create('murid', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('wali_murid_id')->unsigned()->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('nis', 15);
			$table->string('name', 50);
			$table->string('religion', 10);
			$table->integer('gender');
			$table->text('birthplace');
			$table->string('msisdn', 20)->nullable();
			$table->string('email', 50)->nullable();
			$table->date('birthdate');
			$table->string('status_murid', 15);
			$table->string('photo', 100)->nullable();
			$table->integer('kelas');
			$table->text('address');
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('murid');
	}
}