<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChecksTable extends Migration {

	public function up()
	{
		Schema::create('checks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('tenancy_contracts_id')->unsigned();
			$table->integer('amount')->nullable();
			$table->date('check_date')->nullable();
			$table->enum('check_status', array('1', '2', '3', '4', '5', '6'));
			$table->string('check_image');
			$table->string('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('checks');
	}
}