<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenancyContractsTable extends Migration {

	public function up()
	{
		Schema::create('tenancy_contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('property_id')->unsigned()->nullable();
			$table->integer('tenant_id')->unsigned();
			$table->enum('type', array('1', '2'))->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date');
			$table->enum('status', array('0', '1'))->nullable();
			$table->integer('deposit')->nullable();
			$table->integer('total_rent')->nullable();
			$table->integer('unit_number')->nullable();
			$table->string('invoices_image')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tenancy_contracts');
	}
}