<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantTable extends Migration {

	public function up()
	{
		Schema::create('tenant', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('full_name', 500)->nullable();
			$table->integer('emirate_ID')->nullable();
			$table->string('email', 100)->nullable();
			$table->date('date_of_birth')->nullable();
			$table->enum('gender', array('1', '2'));
			$table->string('marital_status')->nullable();
			$table->string('nationality')->nullable();
			$table->string('phone');
			$table->string('tenant_image', 500)->nullable();
			$table->string('emirate_id_image')->nullable();
			$table->string('visa_image', 500)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tenant');
	}
}