<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->text('desc');
			$table->float('sale_price');
			$table->enum('featured', array('true', 'false'));
			$table->integer('stock');
			$table->float('regular_price');
			$table->integer('user_id')->unsigned();
			$table->integer('type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}