<?php

namespace models;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;
	protected $fillable = array('name', 'desc', 'sale_price', 'featured', 'stock', 'regular_price');

	public function User()
	{
		return $this->belongsTo('models\User', 'user_id');
	}

	public function FavouriteUsers()
	{
		return $this->belongsToMany('models\ProductUser');
	}

	public function UserBasket()
	{
		return $this->belongsToMany('models\Basket');
	}

	public function Orders()
	{
		return $this->belongsToMany('models\ProductOrder');
	}

	public function Categories()
	{
		return $this->belongsToMany('models\CategoryProduct', 'category_id');
	}

	public function Type()
	{
		return $this->belongsTo('models\Type', 'type_id');
	}

}